# -*- coding: utf-8 -*-


BIT_TRIG_DIV=1<<14

BIT_ROMSEL=1<<15

BIT_DIV_ON=1<<0
BIT_DIV_SW=1<<1
BIT_E3h=1<<2
BIT_E7h=1<<3
BIT_EBh=1<<4
BIT_IO_BLK=1<<6




f=open("ESXMMC.BIN","rb") 
ESXMMCROM=f.read()
f.close()

romdata=[]
for addr in range (65536):
    if ((addr&BIT_ROMSEL)!=0):
        #данные на селектор точек входа divmmc
        dataout=0xff^(BIT_IO_BLK)
        
        #переключатель
        if ((addr&BIT_TRIG_DIV)!=0):
            #DIV ROM не активна
            
            #точки входа
            if ((addr&0x3fff)==0)|((addr&0x3fff)==0x8)|((addr&0x3fff)==0x38)|((addr&0x3fff)==0x66)|((addr&0x3fff)==0x4c6)|((addr&0x3fff)==0x562):
                dataout^=BIT_DIV_SW #включение
        else:
            #DIV ROM  активна 
            if ((addr&0x3ff8)==0x1ff8):#точка выхода
                dataout^=BIT_DIV_SW #выключение
        #точка входа TRDOS
        if ((addr&0x3f00)==0x3d00):
            dataout^=BIT_DIV_ON
            dataout|=BIT_DIV_SW
        
        #порты
        addr8=addr&0xff
        if (addr8==0xe3):
            dataout^=BIT_E3h
            dataout|=BIT_IO_BLK
        if (addr8==0xe7):
            dataout^=BIT_E7h
            dataout|=BIT_IO_BLK
            
        if (addr8==0xeB):
            dataout^=BIT_EBh
            dataout|=BIT_IO_BLK
            
        
        
        romdata.append(dataout)

    else:
        #данные пошивки divmmc
        #просто повторить прошивку 4 раза
        
        romdata.append(ESXMMCROM[addr&0x1fff])

f=open("ROM.bin","wb")  
f.write(bytes(romdata))
f.close()
exit(0)
