﻿
FILES  EQU 3    ;Сколько файлов будем подгружать (без учёта загрузчика)
                ;Максимальное количество файлов - 18


       ORG #6000

       JR BEGIN

       DEFW #6000 ;адрес компиляции загрузчика - должен совпадать с ORG!!!


;-- В этом блоке ничего не трогать! ---
TABLE
       DEFS 3    ;сюда пишется адрес игры в ПЗУ

BNK    DEFB #80 ;Значение порта для включения первого банка ПЗУ с играми
                ;Может принимать значения #80 (для работы игры с картриджа),
                ;либо #02 (для загрузки игры со встроенного ПЗУ Эльф).
                ;Этот байт может меняться внешним сборщиком образов ПЗУ.

;Структура таблицы
;       DEFS 3    ;смещение файла относительно начала игры
;       DEFW 0    ;длина файла

;       DEFB #FF  ;конец таблицы

       DEFS FILES*5+5+1   ;Резервируем место для таблицы файлов
                          ;Примерное количество файлов - не более 18


;-------------------------------


BEGIN
       LD SP,#5FFF

       LD A,(BNK)      ;первый банк картриджа / прошивки ПЗУ
       OUT (#5F),A     ;тут находятся модули и распаковщик

       LD HL,HRUST     ;перенос распаковщика в память
       LD DE,DEPACK    ;#5B00
       LD BC,LENDEP
       LDIR

       LD HL,MENU      ;Перенос модуля меню в память
       LD DE,MODADR    ;#7000
       LD BC,LENMENU
       LDIR
       LD HL,STRMENU   ;Адрес строк меню
       LD DE,OPTIONS   ;Адрес массива для опций меню
       CALL MODADR     ;Вызов меню

       LD A,1          ;загрузка заставки
       LD DE,#8000
       PUSH DE
       CALL LOAD

       POP HL          ;распаковка заставки
       LD DE,#4000
       CALL DEPACK

       LD A,2          ;Загрузка главного блока игры
       LD DE,#6500
       PUSH DE
       CALL LOAD

       POP HL          ;Распаковка главного блока игры
       LD DE,#6500
       CALL DEPACK

       LD A,3          ;Догрузка главного блока игры.
       LD DE,#FF00
       CALL LOAD

;Hrust плохо распаковывает файлы, которые имеют концовку "впритык" к концу
;памяти, поэтому главный блок игры разбит на 2 куска.

       LD A,1          ;Включаем ПЗУ с BASIC-48
       OUT (#5F),A


       LD IX,OPTIONS ;Адрес опций меню
       LD A,(IX+0)   ;Первая опция
       OR A
       JR Z,OPT2

;Действия для первой опции - бесконечные жизни
       LD A,#21
       LD (46280),A

OPT2   LD A,(IX+1)  ;Вторая опция
       OR A
       JR Z,STRT

;Действия для второй опции - неуязвимость
       XOR A
       LD (45774),A


;Старт игры
STRT   JP #873C


LOAD   LD HL,TABLE
       JP LDBLK


;----- ПАРАМЕТРЫ ДЛЯ МЕНЮ ЧИТОВ -----
OPTIONS DEFS 2   ;Массив для опций меню с читами
                 ;Число после DEFS - количество опций в меню с читами

;Массив строк опций меню. Конец строки - 0, конец массива - #FF
STRMENU
  DEFM 'BESKONE^NYE VIZNI'
  DEFB 0     ;0-конец строки
  DEFM 'NEUQZWIMOSTX'
  DEFB 0
  DEFB #FF   ;#FF-конец массива строк меню



       INCLUDE "../../files/vars.asm"