﻿
FILES  EQU 2    ;Сколько файлов будем подгружать (без учёта загрузчика)
                ;Максимальное количество файлов - 18


       ORG #6000

       JR BEGIN

       DEFW #6000 ;адрес компиляции загрузчика - должен совпадать с ORG!!!


;-- В этом блоке ничего не трогать! ---
TABLE
       DEFS 3    ;сюда пишется адрес игры в ПЗУ

BNK    DEFB #80 ;Значение порта для включения первого банка ПЗУ с играми
                ;Может принимать значения #80 (для работы игры с картриджа),
                ;либо #02 (для загрузки игры со встроенного ПЗУ Эльф).
                ;Этот байт меняется внешним сборщиком образов ПЗУ

;Структура таблицы
;       DEFS 3    ;смещение файла относительно начала игры
;       DEFW 0    ;длина файла

;       DEFB #FF  ;конец таблицы

       DEFS FILES*5+5+1   ;Резервируем место для таблицы файлов
                          ;Примерное количество файлов - не более 18

;-------------------------------


BEGIN
       LD SP,#5FFF

       LD A,(BNK)      ;первый банк картриджа / прошивки ПЗУ
       OUT (#5F),A     ;тут находятся модули и распаковщик

       LD HL,HRUST     ;перенос распаковщика в память
       LD DE,DEPACK    ;#5B00
       LD BC,LENDEP
       LDIR

       LD HL,MENU      ;Перенос модуля меню в память
       LD DE,MODADR    ;#7000
       LD BC,LENMENU
       LDIR
       LD HL,STRMENU   ;Адрес строк меню
       LD DE,OPTIONS   ;Адрес массива для опций меню
       CALL MODADR     ;Вызов меню


       LD A,2         ;загрузка упакованной заставки
       LD DE,#8000
       LD HL,TABLE
       CALL LDBLK

       LD HL,#8000    ;распаковка заставки
       LD DE,#4000
       CALL DEPACK

       LD A,1         ;загрузка основного кодового блока
       LD DE,#7514
       LD HL,TABLE
       CALL LDBLK

       LD A,1
       OUT (#5F),A

       LD HL,#7514   ;распаковка основного кодового блока
       LD DE,#7514
       CALL DEPACK


;Пауза перед запуском игры, чтобы полюбоваться заставкой

;Блок функций доступен из 0-го банка ПЗУ картриджа или 2-го банка ПЗУ Эльф
       LD A,(BNK)   ;Первый банк картриджа / прошивки ПЗУ
       OUT (#5F),A
       CALL FUNC+0  ;Функция 0


       LD IX,OPTIONS ;Адрес опций меню
       LD A,(IX+0)   ;Первая опция
       OR A
       JR Z,OPT2


        ;Действия для первой опции
       XOR A         ;бесконечная энергия
       LD (44111),A

OPT2   LD A,(IX+1)  ;Вторая опция
       OR A
       JR Z,START

        ;Действия для второй опции
       XOR A        ;бесконечные бомбы
       LD (44178),A

;Старт игры
START  JP #7514



;----- ПАРАМЕТРЫ ДЛЯ МЕНЮ ЧИТОВ -----
OPTIONS DEFS 2   ;Массив для опций меню с читами
                 ;Число после DEFS - количество опций в меню с читами

;Массив строк опций меню. Конец строки - 0, конец массива - #FF
STRMENU
       DEFM 'BESKONE^NAQ \NERGIQ'
       DEFB 0
       DEFM 'BESKONE^NYE BOMBY'
       DEFB 0
       DEFB #FF   ;#FF-конец массива строк меню


       INCLUDE "../../files/vars.asm"