﻿
FILES  EQU 7    ;Сколько файлов будем подгружать (без учёта загрузчика)
                ;Максимальное количество файлов - 18


       ORG #5F00

       JR BEGIN

       DEFW #5F00 ;адрес компиляции загрузчика - должен совпадать с ORG!!!


;-- В этом блоке ничего не трогать! ---
TABLE
       DEFS 3    ;сюда пишется адрес игры в ПЗУ

BNK    DEFB #80 ;Значение порта для включения первого банка ПЗУ с играми
                ;Может принимать значения #80 (для работы игры с картриджа),
                ;либо #02 (для загрузки игры со встроенного ПЗУ Эльф).
                ;Этот байт меняется внешним сборщиком образов ПЗУ

;Структура таблицы
;       DEFS 3    ;смещение файла относительно начала игры
;       DEFW 0    ;длина файла

;       DEFB #FF  ;конец таблицы

       DEFS FILES*5+5+1   ;Резервируем место для таблицы файлов
                          ;Примерное количество файлов - не более 18



;-------------------------------


BEGIN
       LD SP,#5DFF

       LD A,(BNK)      ;0-й банк картриджа
       OUT (#5F),A     ;тут находятся модули и распаковщик


       LD HL,CH128    ;Вызов модуля проверки ОЗУ на 128К
       CALL MOD       ;После вызова модуля банк ПЗУ не меняется


       LD HL,HRUST    ;перенос распаковщика в память
       LD DE,DEPACK   ;#5B00
       LD BC,LENDEP
       LDIR

       LD HL,MENU      ;Перенос модуля меню в память
       LD DE,MODADR    ;#7000
       LD BC,LENMENU
       LDIR
       LD HL,STRMENU   ;Адрес строк меню
       LD DE,OPTIONS   ;Адрес массива для опций меню
       CALL MODADR     ;Вызов меню


       LD A,7        ;Загрузка и распаковка заставки
       LD DE,#8000
       PUSH DE
       CALL LOAD
       POP HL
       LD D,#40
       LD E,L
       CALL DEPACK

       LD HL,#1101
       CALL LBANK

       LD HL,#1302
       CALL LBANK

       LD HL,#1403
       CALL LBANK

       LD HL,#1604
       CALL LBANK

       LD HL,#1705
       CALL LBANK

       LD BC,#7FFD
       LD A,#10+0
       OUT (C),A
       LD A,6          ;Загрузка главного блока игры
       LD DE,25000
       CALL LOAD

       LD HL,25000      ;Распаковка главного блока игры
       LD D,H
       LD E,L
       CALL DEPACK



;Пауза перед запуском игры, чтобы полюбоваться заставкой
;       LD A,($BNK)  ;Блок функций доступен из 0-го банка ПЗУ картриджа
;       OUT (#5F),A
;       CALL $FUNC+0 ;Функция 0
       LD A,1       ;После паузы включаем ПЗУ с BASIC-48
       OUT (#5F),A


       LD IX,OPTIONS ;Адрес опций меню
       LD A,(IX+0)   ;Первая опция
       OR A
       JR Z,OPT2

;Действия для первой опции
       XOR A         ;Бесконечные жизни
       LD (#7E34),A

OPT2   LD A,(IX+1)  ;Вторая опция
       OR A
       JR Z,OPT3

;Действия для второй опции
       XOR A          ;Бесконечное время
       LD (#7C47),A


OPT3   LD A,(IX+2)  ;Третья опция
       OR A
       JR Z,OPT4

;Действия для третьей опции
       XOR A            ;Бесконечное оружие
       LD (38450),A


OPT4   LD A,(IX+3)  ;Четвёртая опция
       OR A
       JR Z,START

;Действия для четвёртой опции
       LD A,#18      ;Откючение музыки при игре
       LD (#7A53),A


;Старт игры
START  JP #81BC


LBANK  LD A,H
       LD BC,#7FFD
       OUT (C),A
       LD A,L
       LD DE,#C000
       CALL LOAD
       LD HL,#C000   ;распаковка загруженного блока
       LD DE,#C000
       JP DEPACK

LOAD   LD HL,TABLE
       JP LDBLK


;--- ПОДПРОГРАММЫ -----

;Загрузка и запуск модуля проверки на 128К либо проверки на новодел
MOD    LD DE,MODADR  ;адрес компиляции модуля
       LD BC,#0100   ;максимальная длина модуля
       LDIR
       JP MODADR     ;запуск модуля


;----- ПАРАМЕТРЫ ДЛЯ МЕНЮ ЧИТОВ -----
OPTIONS DEFS 4   ;Массив для опций меню с читами
                  ;Число после DEFS - количество опций в меню с читами

;Массив строк опций меню. Конец строки - 0, конец массива - #FF
STRMENU
 DEFM 'BESKONE^NYE VIZNI'
 DEFB 0
 DEFM 'OTKL@^ENIE TAJMERA'
 DEFB 0
 DEFM 'BESKONE^NYE PATRONY'
 DEFB 0
 DEFM 'OTKL@^ENIE FONOWOJ MUZYKI'
 DEFB 0
 DEFB #FF   ;#FF-конец массива строк меню



       INCLUDE "../../files/vars.asm"