﻿
FILES  EQU 7    ;Сколько файлов будем подгружать (без учёта загрузчика)
                ;Максимальное количество файлов - 18


       ORG #5D00

       JR BEGIN

       DEFW #5D00 ;адрес компиляции загрузчика - должен совпадать с ORG!!!


;-- В этом блоке ничего не трогать! ---
TABLE
       DEFS 3    ;сюда пишется адрес игры в ПЗУ

BNK    DEFB #80 ;Значение порта для включения первого банка ПЗУ с играми
                ;Может принимать значения #80 (для работы игры с картриджа),
                ;либо #02 (для загрузки игры со встроенного ПЗУ Эльф).
                ;Этот байт меняется внешним сборщиком образов ПЗУ

;Структура таблицы
;       DEFS 3    ;смещение файла относительно начала игры
;       DEFW 0    ;длина файла

;       DEFB #FF  ;конец таблицы

       DEFS FILES*5+5+1   ;Резервируем место для таблицы файлов
                          ;Примерное количество файлов - не более 18

;-------------------------------


BEGIN
       LD SP,#5CFF

       LD A,(BNK)      ;0-й банк картриджа
       OUT (#5F),A     ;тут находятся модули и распаковщик


       LD HL,CH128     ;Вызов модуля проверки ОЗУ на 128К
       CALL MOD        ;После вызова модуля банк ПЗУ не меняется

       LD HL,HRUST     ;перенос распаковщика в память
       LD DE,DEPACK    ;#5B00
       LD BC,LENDEP
       LDIR

       LD HL,MENU      ;Перенос модуля меню в память
       LD DE,MODADR    ;#7000
       LD BC,LENMENU
       LDIR
       LD HL,STRMENU    ;Адрес строк меню
       LD DE,OPTIONS    ;Адрес массива для опций меню
       CALL MODADR      ;Вызов меню

       LD A,7          ;Загрузка заставки
       LD DE,#6000
       CALL LOAD
       LD HL,#6000     ;Распаковка заставки
       LD DE,#4000
       CALL DEPACK

       LD HL,#0111
       LD DE,#CD80
       CALL LBANK

       LD HL,#0213
       LD DE,#C000
       CALL LBANK

       LD HL,#0314
       LD DE,#C000
       CALL LBANK

       LD HL,#0416
       LD DE,#C000
       CALL LBANK

       LD HL,#0517
       LD DE,#C000
       CALL LBANK

       LD A,#10
       LD BC,#7FFD
       OUT (C),A

       LD A,6          ;Загрузка главного блока игры
       LD DE,#6000
       CALL LOAD

       LD A,1         ;включаем ПЗУ с BASIC-48
       OUT (#5F),A

       LD HL,#6000     ;Распаковка главного блока игры
       LD D,H
       LD E,L
       CALL DEPACK


       LD IX,OPTIONS ;Адрес опций меню
       LD A,(IX+0)   ;Первая опция
       OR A
       JR Z,OPT2

        ;Действия для первой опции
       XOR A
       LD (#8A30),A

OPT2   LD A,(IX+1)  ;Вторая опция
       OR A
       JR Z,OPT3

        ;Действия для второй опции
       XOR A
       LD (#959F),A

OPT3   LD A,(IX+2)  ;Третья опция
       OR A
       JR Z,OPT4

       ;Действия для третьей опции
       XOR A
       LD (#9B42),A

OPT4

;Старт игры
       JP #7B8F



;--- ПОДПРОГРАММЫ -----

LBANK  LD BC,#7FFD
       OUT (C),L
       LD A,H
       PUSH DE
       CALL LOAD
       POP DE
       LD H,D
       LD L,E
       JP DEPACK

LOAD   LD HL,TABLE
       JP LDBLK

;Загрузка и запуск модуля проверки на 128К либо проверки на новодел
MOD    LD DE,MODADR  ;адрес компиляции модуля
       LD BC,#0100   ;максимальная длина модуля
       LDIR
       JP MODADR     ;запуск модуля


;----- ПАРАМЕТРЫ ДЛЯ МЕНЮ ЧИТОВ -----
OPTIONS DEFS 3    ;Массив для опций меню с читами
                  ;Число после DEFS - количество опций в меню с читами

;Массив строк опций меню. Конец строки - 0, конец массива - #FF
STRMENU
   DEFM 'BESKONE^NYE VIZNI'
   DEFB 0     ;0-конец строки
   DEFM 'BESKONE^NYE PATRONY'
   DEFB 0
   DEFM 'BESKONE^NYE BOMBY'
   DEFB 0
   DEFB #FF   ;#FF-конец массива строк меню


       INCLUDE "../../files/vars.asm"