﻿
FILES  EQU 7    ;Сколько файлов будем подгружать (без учёта загрузчика)
                ;Максимальное количество файлов - 18


       ORG #6000

       JR BEGIN

       DEFW #6000 ;адрес компиляции загрузчика - должен совпадать с ORG!!!


;-- В этом блоке ничего не трогать! ---
TABLE
       DEFS 3    ;сюда пишется адрес игры в ПЗУ

BNK    DEFB #80 ;Значение порта для включения первого банка ПЗУ с играми
                ;Может принимать значения #80 (для работы игры с картриджа),
                ;либо #02 (для загрузки игры со встроенного ПЗУ Эльф).
                ;Этот байт меняется внешним сборщиком образов ПЗУ

;Структура таблицы
;       DEFS 3    ;смещение файла относительно начала игры
;       DEFW 0    ;длина файла

;       DEFB #FF  ;конец таблицы

       DEFS FILES*5+5+1   ;Резервируем место для таблицы файлов
                          ;Примерное количество файлов - не более 18

;-------------------------------


BEGIN
       LD SP,#5FFF

       LD A,(BNK)      ;0-й банк картриджа
       OUT (#5F),A     ;тут находятся модули и распаковщик


       LD HL,CH128    ;Вызов модуля проверки ОЗУ на 128К
       CALL MOD       ;После вызова модуля банк ПЗУ не меняется

       LD HL,HRUST    ;перенос распаковщика в память
       LD DE,DEPACK   ;#5B00
       LD BC,LENDEP
       LDIR

       LD HL,MENU     ;Перенос модуля меню в память
       LD DE,MODADR   ;#7000
       LD BC,LENMENU
       LDIR
       LD HL,STRMENU    ;Адрес строк меню
       LD DE,OPTIONS    ;Адрес массива для опций меню
       CALL MODADR      ;Вызов меню

       LD A,6       ;Загрузка и распаковка заставки
       LD DE,#8000
       PUSH DE
       CALL LOAD
       POP HL
       LD DE,#4000
       CALL DEPACK

       LD HL,#0117
       CALL LBANK

       LD HL,#0216
       CALL LBANK

       LD HL,#0314
       CALL LBANK

       LD HL,#0413
       CALL LBANK

       LD HL,#0511
       CALL LBANK

       LD A,#10
       LD BC,#7FFD
       OUT (C),A

       LD A,7          ;Загрузка главного блока игры
       LD DE,#64D7
       CALL LOAD

       LD HL,#64D7     ;Распаковка главного блока игры
       LD D,H
       LD E,L
       CALL DEPACK

       LD A,1       ;После паузы включаем ПЗУ с BASIC-48
       OUT (#5F),A

       LD IX,OPTIONS ;Адрес опций меню
       LD A,(IX+0)   ;Первая опция
       OR A
       JR Z,OPT2

        ;Действия для первой опции - бесконечные жизни
       XOR A          ;Бесконечные жизни
       LD (#9E12),A
       LD A,#C3
       LD (#9E13),A


OPT2   LD A,(IX+1)  ;Вторая опция
       OR A
       JR Z,OPT3

        ;Действия для второй опции - отключение времени
       XOR A          ;Бесконечное время
       LD (#9B67),A
       LD A,#18
       LD (#9B68),A


OPT3   LD A,(IX+2)  ;Третья опция
       OR A
       JR Z,START

        ;Действия для третьей опции - отключение фоновой музыки
       LD HL,#1717      ;Нет фоновой AY музыки при игре
       LD (#7FE3),HL    ;Заполняем 4 фоновых музыки для каждого из уровней
       LD (#7FE5),HL    ;номером музыки с тишиной.



;Старт игры
START
;       LD A,#C9       ;Неуязвимость - не уменьшается энергия
;       LD (#827B),A
;       LD (#8BEA),A

       JP #7C3E



;--- ПОДПРОГРАММЫ -----

;Загрузка и запуск модуля проверки на 128К либо проверки на новодел
MOD    LD DE,MODADR  ;адрес компиляции модуля
       LD BC,#0100   ;максимальная длина модуля
       LDIR
       JP MODADR     ;запуск модуля

LBANK  LD A,L
       LD BC,#7FFD
       OUT (C),A
       LD A,H
       LD DE,#C000
       CALL LOAD
       LD HL,#C000
       LD D,H
       LD E,L
       JP DEPACK

LOAD   LD HL,TABLE
       JP LDBLK

;----- ПАРАМЕТРЫ ДЛЯ МЕНЮ ЧИТОВ -----
OPTIONS DEFS 3    ;Массив для опций меню с читами
                  ;Число после DEFS - количество опций в меню с читами

;Массив строк опций меню. Конец строки - 0, конец массива - #FF
STRMENU
  DEFM 'BESKONE^NYE VIZNI'
  DEFB 0
  DEFM 'OTKL@^ENIE TAJMERA'
  DEFB 0
  DEFM 'BEZ FONOWOJ MUZYKI'
  DEFB 0
  DEFB #FF



       INCLUDE "../../files/vars.asm"