﻿
FILES  EQU 8    ;Сколько файлов будем подгружать (без учёта загрузчика)
                ;Максимальное количество файлов - 18


       ORG #5E00

       JR BEGIN

       DEFW #5E00 ;адрес компиляции загрузчика - должен совпадать с ORG!!!


;-- В этом блоке ничего не трогать! ---
TABLE
       DEFS 3    ;сюда пишется адрес игры в ПЗУ

BNK    DEFB #80 ;Значение порта для включения первого банка ПЗУ с играми
                ;Может принимать значения #80 (для работы игры с картриджа),
                ;либо #02 (для загрузки игры со встроенного ПЗУ Эльф).
                ;Этот байт меняется внешним сборщиком образов ПЗУ

;Структура таблицы
;       DEFS 3    ;смещение файла относительно начала игры
;       DEFW 0    ;длина файла

;       DEFB #FF  ;конец таблицы

       DEFS FILES*5+5+1   ;Резервируем место для таблицы файлов
                          ;Примерное количество файлов - не более 18


;-------------------------------


BEGIN
       LD SP,#5DF0

       LD A,(BNK)      ;первый банк картриджа / прошивки ПЗУ
       OUT (#5F),A     ;тут находятся модули и распаковщик


       LD HL,CH128     ;Вызов модуля проверки ОЗУ на 128К
       CALL MOD        ;После вызова модуля банк ПЗУ не меняется

       LD HL,HRUST     ;перенос распаковщика в память
       LD DE,DEPACK    ;#5B00
       LD BC,LENDEP
       LDIR

       LD HL,MENU      ;Перенос модуля меню в память
       LD DE,MODADR    ;#7000
       LD BC,LENMENU
       LDIR
       LD HL,STRMENU   ;Адрес строк меню
       LD DE,OPTIONS   ;Адрес массива для опций меню
       CALL MODADR     ;Вызов меню

       LD A,8        ;Загрузка и распаковка заставки
       LD DE,#8000
       CALL LOAD
       LD HL,#8000
       LD DE,#4000
       CALL DEPACK

       LD DE,#1101    ;BANK 1
       CALL LOADB

       LD DE,#1302    ;BANK 3
       CALL LOADB

       LD DE,#1403    ;BANK 4
       CALL LOADB

       LD DE,#1604    ;BANK 6
       CALL LOADB

       LD DE,#1705    ;BANK 7
       CALL LOADB

       LD A,#10
       LD BC,#7FFD
       OUT (C),A
       LD A,6
       LD DE,25000
       CALL LOAD
       LD HL,25000
       LD DE,25000
       CALL DEPACK

       LD HL,#4000
       LD DE,#4001
       LD BC,6912-1
       LD (HL),0
       LDIR

       LD A,7
       LD DE,#4000
       CALL LOAD
       LD HL,#4000
       LD DE,#4000
       CALL DEPACK

       LD A,1
       OUT (#5F),A

       CALL #4000

       LD IX,OPTIONS ;Адрес опций меню
       LD A,(IX+0)   ;Первая опция
       OR A
       JR Z,OPT2

;Действия для первой опции
       XOR A          ;Бесконечные жизни
       LD (#91FE),A


OPT2   LD A,(IX+1)  ;Вторая опция
       OR A
       JR Z,OPT3

;Действия для второй опции
       LD A,#C9      ;Неуязвимость
       LD (#91F2),A


OPT3   LD A,(IX+2)  ;Третья опция
       OR A
       JR Z,OPT4

;Действия для третьей опции
       LD A,#18      ;Autofire
       LD (#95AB),A



OPT4   LD A,(IX+3)  ;Четвёртая опция
       OR A
       JR Z,OPT5

       LD A,#23      ;Отключаем музыку
       LD (#8384),A
       LD A,#BE
       LD (#8385),A


OPT5   LD A,(IX+4)  ;Пятая опция
       OR A
       JR Z,STRT

       LD A,#A0        ;Без бегущей строки
       LD (#81A9),A


;Старт игры
STRT   JP 25000


LOADB  LD BC,#7FFD
       OUT (C),D
       LD A,E
       LD DE,#C000
       CALL LOAD
       LD HL,#C000
       LD DE,#C000
       JP DEPACK

LOAD   LD HL,TABLE
       JP LDBLK

;--- ПОДПРОГРАММЫ -----

;Загрузка и запуск модуля проверки на 128К либо проверки на новодел
MOD    LD DE,MODADR  ;адрес компиляции модуля
       LD BC,#0100   ;максимальная длина модуля
       LDIR
       JP MODADR     ;запуск модуля


;----- ПАРАМЕТРЫ ДЛЯ МЕНЮ ЧИТОВ -----
OPTIONS DEFS 5   ;Массив для опций меню с читами
                 ;Число после DEFS - количество опций в меню с читами

;Массив строк опций меню. Конец строки - 0, конец массива - #FF
STRMENU
       DEFM 'BESKONE^NYE VIZNI'
       DEFB 0
       DEFM 'NEUQZWIMOSTX'
       DEFB 0
       DEFM 'AWTOMATI^ESKIJ OGONX'
       DEFB 0
       DEFM 'BEZ MUZYKI'
       DEFB 0
       DEFM 'BEZ BEGU]EJ STROKI'
       DEFB 0
       DEFB #FF


       INCLUDE "../../files/vars.asm"