﻿
FILES  EQU 2    ;Сколько файлов будем подгружать (без учёта загрузчика)
                ;Максимальное количество файлов - 18


       ORG #D000

       JR BEGIN

       DEFW #D000 ;адрес компиляции загрузчика - должен совпадать с ORG!!!


;-- В этом блоке ничего не трогать! ---
TABLE
       DEFS 3    ;сюда пишется адрес игры в ПЗУ

BNK    DEFB #80 ;Значение порта для включения первого банка ПЗУ с играми
                ;Может принимать значения #80 (для работы игры с картриджа),
                ;либо #02 (для загрузки игры со встроенного ПЗУ Эльф).
                ;Этот байт меняется внешним сборщиком образов ПЗУ

;Структура таблицы
;       DEFS 3    ;смещение файла относительно начала игры
;       DEFW 0    ;длина файла

;       DEFB #FF  ;конец таблицы

       DEFS FILES*5+5+1   ;Резервируем место для таблицы файлов
                          ;Примерное количество файлов - не более 18

;-------------------------------


BEGIN
       LD SP,#FFFF

       LD A,(BNK)      ;0-й банк картриджа
       OUT (#5F),A     ;тут находятся модули и распаковщик

       LD HL,HRUST     ;перенос распаковщика в память
       LD DE,#CF00
       LD BC,LENDEP
       LDIR

       LD HL,MENU      ;Перенос модуля меню в память
       LD DE,MODADR    ;#7000
       LD BC,LENMENU
       LDIR
       LD HL,STRMENU    ;Адрес строк меню
       LD DE,OPTIONS    ;Адрес массива для опций меню
       CALL MODADR      ;Вызов меню

       LD A,1          ;Загрузка заставки
       LD DE,#8000
       LD HL,TABLE
       CALL LDBLK

       LD HL,#8000     ;Распаковка заставки
       LD DE,#4000
       CALL #CF00

       LD A,2
       OUT (#FE),A

       LD A,2          ;Загрузка главного блока игры
       LD DE,#5B00
       LD HL,TABLE
       CALL LDBLK

       LD HL,#5B00     ;Распаковка главного блока игры
       LD DE,#5B00
       CALL #CF00

;Пауза перед запуском игры, чтобы полюбоваться заставкой
       LD A,(BNK)   ;Блок функций доступен из 0-го банка ПЗУ картриджа
       OUT (#5F),A
       CALL FUNC+0  ;Функция 0

       LD A,1       ;После паузы включаем ПЗУ с BASIC-48
       OUT (#5F),A

       LD IX,OPTIONS ;Адрес опций меню
       LD A,(IX+0)   ;Первая опция
       OR A
       JR Z,OPT2

        ;Действия для первой опции - бесконечные жизни
       XOR A
       LD (#A3A8),A

OPT2   LD A,(IX+1)  ;Вторая опция
       OR A
       JR Z,OPT3

        ;Действия для второй опции - бесконечная вода
       XOR A
       LD (32822),A


OPT3   LD A,(IX+2)  ;Третья опция
       OR A
       JR Z,OPT4

       ;Действия для третьей опции- бесконечная пена
       XOR A
       LD (32928),A

OPT4



;Старт игры
       JP #AA66



;----- ПАРАМЕТРЫ ДЛЯ МЕНЮ ЧИТОВ -----
OPTIONS DEFS 3   ;Массив для опций меню с читами
                 ;Число после DEFS - количество опций в меню с читами

;Массив строк опций меню. Конец строки - 0, конец массива - #FF
STRMENU
 DEFM 'BESKONE^NYE VIZNI'
 DEFB 0     ;0-конец строки
 DEFM 'BESKONE^NAQ WODA'
 DEFB 0
 DEFM 'BESKONE^NAQ PENA'
 DEFB 0
 DEFB #FF   ;#FF-конец массива строк меню

       INCLUDE "../../files/vars.asm"