﻿;Загрузчик должен иметь длину 256 байт или более!!!


FILES  EQU 3    ;Сколько файлов будем подгружать (без учёта загрузчика)
                ;Максимальное количество файлов - 18


       ORG #5D00

       JR BEGIN

       DEFW #5D00 ;адрес компиляции загрузчика - должен совпадать с ORG!!!


;-- В этом блоке ничего не трогать! ---
TABLE
       DEFS 3    ;сюда пишется адрес игры в ПЗУ

BNK    DEFB #80 ;Значение порта для включения первого банка ПЗУ с играми
                ;Может принимать значения #80 (для работы игры с картриджа),
                ;либо #02 (для загрузки игры со встроенного ПЗУ Эльф).
                ;Этот байт меняется внешним сборщиком образов ПЗУ

;Структура таблицы
;       DEFS 3    ;смещение файла относительно начала игры
;       DEFW 0    ;длина файла

;       DEFB #FF  ;конец таблицы

       DEFS FILES*5+5+1   ;Резервируем место для таблицы файлов
                          ;Примерное количество файлов - не более 18

;-------------------------------


BEGIN
       LD SP,#5CF7

       LD A,(BNK)      ;первый банк картриджа / прошивки ПЗУ
       OUT (#5F),A     ;тут находятся модули и распаковщик

       LD HL,HRUST     ;перенос распаковщика в память
       LD DE,DEPACK    ;#5B00
       LD BC,LENDEP
       LDIR

       LD HL,MENU      ;Перенос модуля меню в память
       LD DE,MODADR    ;#7000
       LD BC,LENMENU
       LDIR
       LD HL,STRMENU   ;Адрес строк меню
       LD DE,OPTIONS   ;Адрес массива для опций меню
       CALL MODADR     ;Вызов меню

       LD A,1         ;Загрузка заставки
       LD DE,#6000
       CALL LOAD

       LD HL,#6000    ;Распаковка заставки
       LD DE,#4000
       CALL DEPACK

       LD A,2         ;Загрузка основного блока
       LD DE,#6000
       CALL LOAD

       LD HL,#6000
       LD DE,#6000
       CALL DEPACK




;Пауза перед запуском игры, чтобы полюбоваться заставкой

;Блок функций доступен из 0-го банка ПЗУ картриджа или 2-го банка ПЗУ Эльф
       LD A,(BNK)   ;Первый банк картриджа / прошивки ПЗУ
       OUT (#5F),A
       CALL FUNC+0  ;Функция 0

       LD HL,#58C0    ;Верхние 6 строк экрана оставляем, поэтому чистим
       LD DE,#58C1    ;знакоместа начиная с 7-й строки.
       LD BC,#0240-1
       LD (HL),0
       LDIR

       LD A,3         ;Загрузка остатка основного блока кодов.
       LD DE,#4900    ;Пока в экран.
       CALL LOAD

       LD A,1
       OUT (#5F),A


       LD IX,OPTIONS ;Адрес опций меню
       LD A,(IX+0)   ;Первая опция
       OR A
       JR Z,START

;Действия для первой опции
       LD A,182       ;Бесконечные жизни
       LD (#94E3),A

        ;Действия для второй опции
;       LD A,#C9      ;Прохождение сквозь стены
;       LD (#C142),A

;Старт игры
START
       LD HL,STRT        ;Переносим запускалку игры в экранную область
       LD DE,#4800
       LD BC,STEND-STRT
       LDIR

       JP #4800

;Запускалка игры
STRT   LD HL,#4900    ;Переносим остаток основного блока игры на своё место
       LD DE,#5B00
       LD BC,#0500
       LDIR

       LD SP,#9241    ;Запуск игры
       IM 2

       JP #5DF7
STEND

LOAD   LD HL,TABLE
       JP LDBLK


;----- ПАРАМЕТРЫ ДЛЯ МЕНЮ ЧИТОВ -----
OPTIONS DEFS 1   ;Массив для опций меню с читами
                 ;Число после DEFS - количество опций в меню с читами

;Массив строк опций меню. Конец строки - 0, конец массива - #FF
STRMENU
  DEFM 'BESKONE^NYE VIZNI'
  DEFB 0     ;0-конец строки
;  следующая строка, если надо и т.п.
  DEFB #FF   ;#FF-конец массива строк меню


       INCLUDE "../../files/vars.asm"