﻿;Загрузчик должен иметь длину 256 байт или более!!!


FILES  EQU 6    ;Сколько файлов будем подгружать (без учёта загрузчика)
                ;Максимальное количество файлов - 18


       ORG #5BBA

       JR BEGIN

       DEFW #5BBA ;адрес компиляции загрузчика - должен совпадать с ORG!!!


;-- В этом блоке ничего не трогать! ---
TABLE
       DEFS 3    ;сюда пишется адрес игры в ПЗУ

BNK    DEFB #80 ;Значение порта для включения первого банка ПЗУ с играми
                ;Может принимать значения #80 (для работы игры с картриджа),
                ;либо #02 (для загрузки игры со встроенного ПЗУ Эльф).
                ;Этот байт может меняться внешним сборщиком образов ПЗУ.

;Структура таблицы
;       DEFS 3    ;смещение файла относительно начала игры
;       DEFW 0    ;длина файла

;       DEFB #FF  ;конец таблицы

       DEFS FILES*5+5+1   ;Резервируем место для таблицы файлов
                          ;Примерное количество файлов - не более 18


;-------------------------------


BEGIN
       LD SP,#5BB0

       LD A,(BNK)      ;первый банк картриджа / прошивки ПЗУ
       OUT (#5F),A     ;тут находятся модули и распаковщик

       LD HL,HRUST     ;перенос распаковщика в память
       LD DE,#5E00
       LD BC,LENDEP
       LDIR


       LD HL,CH128    ;Вызов модуля проверки ОЗУ на 128К
       CALL MOD       ;После вызова модуля банк ПЗУ не меняется

       LD HL,MENU      ;Перенос модуля меню в память
       LD DE,MODADR    ;#7000
       LD BC,LENMENU
       LDIR
       LD HL,STRMENU   ;Адрес строк меню
       LD DE,OPTIONS   ;Адрес массива для опций меню
       CALL MODADR     ;Вызов меню



       LD A,1          ;Загрузка заставки
       LD DE,#8000
       PUSH DE
       CALL LDBL
       POP HL          ;Распаковка заставки
       LD DE,#4000
       CALL #5E00

       LD HL,#0216    ;файла B6
       CALL LOAD      ;загрузка и распаковка в банк #16

       LD HL,#0317    ;файл B7
       CALL LOAD      ;загрузка и распаковка в банк #17

       LD HL,#0410    ;файл B0
       CALL LOAD      ;;загрузка и распаковка в банк #10

       LD A,5         ;файл B2
       LD DE,#8000
       PUSH DE
       PUSH DE
       CALL LDBL      ;распаковка B2
       POP HL
       POP DE
       CALL #5E00

       LD A,#80
       LD (#BFFF),A

       LD A,6         ;файл C1
       LD DE,#5E00
       CALL LDBL

       LD A,1       ;Включаем ПЗУ с BASIC-48
       OUT (#5F),A


       LD IX,OPTIONS ;Адрес опций меню
       LD A,(IX+0)   ;Первая опция
       OR A
       JR Z,STRT

;Действия для первой опции
       LD A,9         ;9 жизней
       LD (#F508),A


;Старт игры
STRT   LD HL,#2758
       LD DE,#369B
       LD BC,#1621
       EXX
       LD HL,#E381
       LD DE,#E381
       LD BC,#7FFD

       LD IY,#5CC0
       LD IX,#5D46

       LD A,#BE
       LD I,A
       IM 2

       LD A,#54
       EX AF,AF'
       LD A,#44

       LD SP,#96CF
       JP #5E00



;--- ПОДПРОГРАММЫ -----
;Загрузка файла H в #8000 и распаковка в банк L
LOAD   LD A,L
       LD BC,#7FFD
       OUT (C),A
       LD A,H
       LD DE,#8000
       PUSH DE
       CALL LDBL
       POP HL
       LD DE,#C000
       JP #5E00

LDBL   LD HL,TABLE
       JP LDBLK


;Загрузка и запуск модуля проверки на 128К либо проверки на новодел
MOD    LD DE,MODADR ;адрес компиляции модуля
       LD BC,#0100   ;максимальная длина модуля
       LDIR
       JP MODADR    ;запуск модуля


;----- ПАРАМЕТРЫ ДЛЯ МЕНЮ ЧИТОВ -----
OPTIONS DEFS 1   ;Массив для опций меню с читами
                 ;Число после DEFS - количество опций в меню с читами

;Массив строк опций меню. Конец строки - 0, конец массива - #FF
STRMENU
  DEFM 'PODARITX DIZZI 9 VIZNEJ'
  DEFB 0     ;0-конец строки
;  следующая строка, если надо и т.п.
  DEFB #FF   ;#FF-конец массива строк меню


       INCLUDE "../../files/vars.asm"