﻿# Утилита преобразования текстового файла с описанием игры
# (C) Prusak, https://zxbyte.ru

 
import sys
import re


maxOutFileLen = 0x2F4


#----------
# Функции


# Перекодировка кириллицы в кодировку Эльф
def symToAlf (symbol):

	if ord(symbol) < 0x40:
		return symbol

	upperSymbol = symbol.upper()

	if upperSymbol == "А":
		return "A"
	if upperSymbol == "Б":
		return "B"
	if upperSymbol == "В":
		return "W"
	if upperSymbol == "Г":
		return "G"
	if upperSymbol == "Д":
		return "D"
	if upperSymbol == "Е":
		return "E"
	if upperSymbol == "Ё":
		return "E"
	if upperSymbol == "Ж":
		return "V"
	if upperSymbol == "З":
		return "Z"
	if upperSymbol == "И":
		return "I"
	if upperSymbol == "Й":
		return "J"
	if upperSymbol == "К":
		return "K"
	if upperSymbol == "Л":
		return "L"
	if upperSymbol == "М":
		return "M"
	if upperSymbol == "Н":
		return "N"
	if upperSymbol == "О":
		return "O"
	if upperSymbol == "П":
		return "P"
	if upperSymbol == "Р":
		return "R"
	if upperSymbol == "С":
		return "S"
	if upperSymbol == "Т":
		return "T"
	if upperSymbol == "У":
		return "U"
	if upperSymbol == "Ф":
		return "F"
	if upperSymbol == "Х":
		return "H"
	if upperSymbol == "Ц":
		return "C"
	if upperSymbol == "Ч":
		return "^"
	if upperSymbol == "Ш":
		return "["
	if upperSymbol == "Щ":
		return "]"
	if upperSymbol == "Ъ":
		return "'"
	if upperSymbol == "Ы":
		return "Y"
	if upperSymbol == "Ь":
		return "X"
	if upperSymbol == "Э":
		return "\\"
	if upperSymbol == "Ю":
		return "@"
	if upperSymbol == "Я":
		return "Q"

	return " "


# Подсчёт контрольной суммы массива данных. Формат контрольной суммы - как в iS-DOS
def checkSum (massive):
	summa = 0
	i = 0
	while i< len (massive): # сумма всех байтов числа в 16-битном размере
		summa += massive[i]
		if summa > 65535: # приводим сумму к 16-битному значению при переполнении
			summa -= 65536
		i += 1
	return 65536 - summa # 0 - сумма всех байтов = контрольная сумма



# преобразование числа в hex вида #00000, len - формат длины выводимого числа (2, 4 или 6 символов)
def decToHex (arg,len):
	if len == 2:
		return "#" + f"{format (arg,'X'):0>2}"
	if len == 4:
		return "#" + f"{format (arg,'X'):0>4}"
	if len == 6:
		return "#" + f"{format (arg,'X'):0>6}"
	else:
		return "#" + format (arg,'X')





#---------------------
# Начало программы

print ("\n-----------------------")
print ("ALF description builder b20250731 (C)Prusak (https://zxbyte.ru)")

# Обрезаем переданные в программу аргументы (первым всегда является путь к исполняемому файлу программы)
args = sys.argv[1:]

# Если передано недостаточное количество аргументов, выходим с ошибкой
if len(args) < 1:
	print ('Invalid command line syntax')
	sys.exit(1)

# Парсим аргументы на нужные типы (входные файлы, выходной файл, ключи)
i = 0
outputFilePos = ''
inputFilePos = ''
while i < len(args):
	# Проверка на первый указанный файл
	if (outputFilePos == ""):
		outputFilePos = i
	else:
		inputFilePos = i
	i += 1

print ("\n")

# ------------------------------
# Проверка количества аргументов и вывод сообщения об ошибке, если чего-то не хватает
print ("Processing command line arguments... ", end='')
if ((outputFilePos == '') or (inputFilePos == '')):
	print ("ERROR! Not enough arguments")
	sys.exit(1)
else:
	print ("OK")






# --------------------------------


outFileMassive = bytearray (maxOutFileLen) # Задаём массив для формирования выходного файла
i = 0
while i < maxOutFileLen: # Заполняем массив пробелами
	outFileMassive[i] = 0x20
	i += 1

# Открываем входной файл. Он должен быть с кодировкой UTF8!!!
try:
	file = open(args[inputFilePos])
except IOError as e:
	print ("Input file ", end='')
	print (args[inputFilePos], end='')
	print(' - read error or file not exist!')
	sys.exit(1)
else:
# считываем входной файл в список fileMassive
	with open(args[inputFilePos], "rb") as file:
		fileMassive = file.read()
		file.close()
		# проверка считанного файла на BOM (Byte order mark) на принадлежность к UTF-8
		if fileMassive[0] != 0xEF or fileMassive[1] != 0xBB or fileMassive[2] != 0xBF:
			print ("Input file ", end='')
			print (args[inputFilePos], end='')
			print(' - Error, no UTF-8 codepage!')
			sys.exit(1)


# Если нашли BOM, то считываем файл
Inpfile = open(args[inputFilePos], encoding='UTF8')

inpFileContents = Inpfile.readlines() # Считываем весь файл в массив строк



# Создаём выходной файл. Он пока пустой.
outFile = open (args[outputFilePos], "wb")




# Главный цикл. Перебираем строки файла
outFilePos = 0 # Позиция в выходном файле
inpFileLine = 0 # Счётчик строк во входном файле
j = 0 # Позиция в строке выходного файла
maxOutFileLenLimit = False # Признак, что не было переполнения выходного файла по длине
while inpFileLine < len (inpFileContents): # Перебираем строки файла
	stroka = re.sub(r'[^a-zA-Zа-яА-Я0-9\\._;:#$@ \-\n\,()]\"', '', inpFileContents[inpFileLine]) # Убираем из считанной строки все неподходящие символы
	if ord (stroka[0]) < 0x2000: # Отсекаем "левые" комбинации символов в начале строки.
		if stroka[0] != ';': # Строки с комментариями пропускаем
			k = 0
			while k < len (stroka): # Перебираем все символы в строке
				if ord(stroka[k]) == 0x0A and k != 28: # Встретили перенос строки, "добиваем" текущую строку в выходном файле пробелами. k != 28 - если перенос строки был в последней допустимой позиции x=28 строки, то игнорируем его, иначе у нас будет сделана пустая строка с пробелами
					while ((j < 28)): # Остаток строки "добиваем" пробелами
						if maxOutFileLenLimit == False: # Если достигли предела объёма выходного файла, игнорируем
							outFileMassive[outFilePos] = 0x020
						j += 1
						outFilePos += 1 # Следующая позиция в выходном файле
					j = 0 # Позиция в новой строке - 0
					
				if ord(stroka[k]) != 0x0A: # Встретили обычный символ
					if maxOutFileLenLimit == False: # Если достигли предела объёма выходного файла, игнорируем
						outFileMassive[outFilePos] = ord (symToAlf(stroka[k]))
					j += 1
					outFilePos += 1 # Следующая позиция в выходном файле
					if outFilePos == maxOutFileLen: # Если достигли лимита по длине выходного файла
						maxOutFileLenLimit = True
					if j == 28: # Если достигли конца строки в выходном файле, меняем координату на 0
						j = 0

				k += 1 # Следующий символ в строке
					

	inpFileLine += 1 # Следующая строка файла

if maxOutFileLenLimit == True:
	print ("\nWarning! Description file length overflow! Some symbols are excluded from the description.")



outFile.write (outFileMassive) # Пишем в выходной файл сформированный массив данных

outFile.close() # Закрываем выходной файл

# Вывод финальной информации о выходном файле
print ("\nOutput File: " + args[outputFilePos]) # Имя выходного файла

# Длина сформированного файла с прошивкой
print ("Length = ", end='')
print (decToHex (maxOutFileLen, 6), end='') # Конвертация числа в удобный hex вид #xxxxxxx
print (' (dec ', end='')
print (maxOutFileLen, end='')
print (') bytes')

# Контрольная сумма выходного файла
print ("Checksum = ", end='')
print (decToHex (checkSum(outFileMassive),4)) # Конвертация числа в удобный hex вид #xxxxxxx
print ("COMPLETED")

sys.exit(0)