﻿# Сборщик образов картриджей приставки "Эльф"
# Alf TV GAME ROM image builder
# (C) Prusak, https://zxbyte.ru

 
import sys
import configparser
import re

# системные переменные
filesFolder = 'files'		# подпапка для хранения служебных файлов и файла конфигурации
configName = 'config.ini'	# имя файла конфигурации

#----------
# Функции


# Перекодировка кириллицы в кодировку Эльф
def symToAlf (symbol):

	if ord(symbol) < 0x40:
		return symbol

	upperSymbol = symbol.upper()

	if upperSymbol == "А":
		return "A"
	if upperSymbol == "Б":
		return "B"
	if upperSymbol == "В":
		return "W"
	if upperSymbol == "Г":
		return "G"
	if upperSymbol == "Д":
		return "D"
	if upperSymbol == "Е":
		return "E"
	if upperSymbol == "Ё":
		return "E"
	if upperSymbol == "Ж":
		return "V"
	if upperSymbol == "З":
		return "Z"
	if upperSymbol == "И":
		return "I"
	if upperSymbol == "Й":
		return "J"
	if upperSymbol == "К":
		return "K"
	if upperSymbol == "Л":
		return "L"
	if upperSymbol == "М":
		return "M"
	if upperSymbol == "Н":
		return "N"
	if upperSymbol == "О":
		return "O"
	if upperSymbol == "П":
		return "P"
	if upperSymbol == "Р":
		return "R"
	if upperSymbol == "С":
		return "S"
	if upperSymbol == "Т":
		return "T"
	if upperSymbol == "У":
		return "U"
	if upperSymbol == "Ф":
		return "F"
	if upperSymbol == "Х":
		return "H"
	if upperSymbol == "Ц":
		return "C"
	if upperSymbol == "Ч":
		return "^"
	if upperSymbol == "Ш":
		return "["
	if upperSymbol == "Щ":
		return "]"
	if upperSymbol == "Ъ":
		return "'"
	if upperSymbol == "Ы":
		return "Y"
	if upperSymbol == "Ь":
		return "X"
	if upperSymbol == "Э":
		return "\\"
	if upperSymbol == "Ю":
		return "@"
	if upperSymbol == "Я":
		return "Q"

	return " "

# заполнение массива massive байтом num, длина заполнения - len
def fillByte (massive, len, num):
	i = 0
	while i < len:
		massive[i] = num
		i += 1


# перенос данных (len) из одного массива (massive1) c адресом addr1 во второй (massive2) по адресу addr2
def LDIR (massive1, addr1, massive2, addr2, len):
	i = 0
	while i < len:
		massive2[addr2] = massive1[addr1]
		i += 1
		addr1 += 1
		addr2 += 1


# Запись числа (numb) в 2 или 3 байтовой форме (len) в массив (massive) по адресу (addr)
def writeNum (numb, len, massive, addr):
	if len == 2:
		stByte = numb // 256
		mlByte = numb - stByte * 256
		massive[addr] = mlByte
		massive[addr+1] = stByte
	if len == 3:
		sstByte = numb // 65536
		numb1 = numb - sstByte * 65536
		stByte = numb1 // 256
		mlByte = numb1 - stByte * 256
		massive[addr] = mlByte
		massive[addr+1] = stByte
		massive[addr+2] = sstByte
	if ((len != 3) and (len != 2)):
		print ("ERROR: writeNum input parameter length invalid")


# Чтение числа 1,2,3 байта из массива по адресу addr
def readNum (massive, addr, len):
	if len == 1:
		num = massive[addr]
	if len == 2:
		num = massive[addr] + 256 * massive[addr+1]
	if len == 3:
		num = massive[addr] + 256 * massive[addr+1] + 65536 * massive[addr+2]
	if ((len != 1) and (len != 2) and (len != 3)):
		print ("ERROR: readNum input parameter length invalid")

	return num




# Подсчёт контрольной суммы массива данных. Формат контрольной суммы - как в iS-DOS
def checkSum (massive):
	summa = 0
	i = 0
	while i< len (massive): # сумма всех байтов числа в 16-битном размере
		summa += massive[i]
		if summa > 65535: # приводим сумму к 16-битному значению при переполнении
			summa -= 65536
		i += 1
	return 65536 - summa # 0 - сумма всех байтов = контрольная сумма


# преобразование числа в hex вида #00000, len - формат длины выводимого числа (2, 4 или 6 символов)
def decToHex (arg,len):
	if len == 2:
		return "#" + f"{format (arg,'X'):0>2}"
	if len == 4:
		return "#" + f"{format (arg,'X'):0>4}"
	if len == 6:
		return "#" + f"{format (arg,'X'):0>6}"
	else:
		return "#" + format (arg,'X')


# Открывает файл с именем fileName и возвращает его содержимое в виде списка.
def readFile (fileName, folder):
	if folder != '':	# Если задана папка, то добавляем к ней символ "/"
		folder += "/"

	statusXpos = 15 # X координата для печати статуса проверки. Чтобы статусы были выровнены по одной линии
	if len(fileName) < statusXpos:
		probels = statusXpos - len(fileName)
	else: # но если координата "наползает" на имя файла, игнорируем её
		probels = 1
		
	try:
		print (fileName, end='')
		#допечатываем пробелы после имени файла
		i = 0
		while i < probels:
			print (" ", end='')
			i += 1

		file = open(folder + fileName)
	except IOError as e:
		print('ERROR / No file')
		sys.exit(1)
	else:
# считываем входной файл в список fileMassive
		with open(folder + fileName, "rb") as file:
			fileMassive = file.read()
		print ("checksum = ", end='')
		print (decToHex (checkSum(fileMassive),4)) # Конвертация числа в удобный hex вид #xxxxxxx
		return fileMassive


# Чтение параметра из config файла. Если параметра нет, выходим с ошибкой
def readConfig (config1, config2):
	try:
		configItem = config[config1][config2]
	except:
		print ("\nConfig.ini file error")
		sys.exit(1)
	return configItem



#---------------------
# Начало программы

print ("\n---------------------------------------------------------------")
print ("ALF Cartridge ROM builder b20250808 (C)Prusak (https://zxbyte.ru)")


# Проверка наличия конфигурационного файла
try:
	file = open('files/' + configName)
except IOError as e:
	print('\nERROR! No ' + configName + ' file')
	sys.exit(1)

# Читаем конфигурационный файл
config = configparser.ConfigParser()  # создаём объект парсера
config.read("files/" + configName)  # читаем конфиг

hrustAddr = int(readConfig("Addrs","hrustAddr"),16) # Адрес распаковщика Hrust в ПЗУ
hrustLen = int(readConfig("Addrs","hrustLen"),16) # Адрес распаковщика Hrust в ПЗУ
ch128Len = int(readConfig("Addrs","ch128Len"),16) # Длина процедуры CH128 - проверки ОЗУ на 128К
chNovLen = int(readConfig("Addrs","chNovLen"),16) # Длина процедуры проверки на новодел
cheatMenuLen = int(readConfig("Addrs","cheatMenuLen"),16) # Длина меню читов
funcLen = int(readConfig("Addrs","funcLen"),16) # Длина блока дополнительных функций
ldblkLen = int(readConfig("Addrs","ldblkLen"),16) # Длина загрузчика

opisLen = int(readConfig("ALFFiles","opisLen"),16) # Длина описания игры (#02F4 байт)
maxFiles = int(readConfig("ALFFiles","maxFiles"),16) # Максимальное количество файлов, из которых может состоять игра *.alf
maxCartridgeBanksQuantity = int(readConfig("HardConfig","maxCartridgeBanksQuantity"),16) # Максимальное количество банков ПЗУ на картридже
maxROMBanksQuantity = int(readConfig("HardConfig","maxROMBanksQuantity"),16) # Максимальное количество банков ПЗУ для программ во встроенном на плату ПЗУ приставки "Эльф"


ch128Addr = hrustAddr + hrustLen # Адрес подпрограммы проверки ОЗУ на 128К относительно начала 0-го банка ПЗУ
chNovAddr = ch128Addr + ch128Len # Адрес подпрограммы проверки на новодел относительно начала 0-го банка ПЗУ
cheatMenuAddr = chNovAddr + chNovLen # Адрес меню с читами относильно начала 0-го банка ПЗУ
funcAddr = cheatMenuAddr + cheatMenuLen # Адрес блока функций относительно начала 0-го банка ПЗУ
ldblkAddr = funcAddr + funcLen # Адрес загрузчика относительно начала 0-го банка ПЗУ
gamesAddr = ldblkAddr + ldblkLen # Адрес начала данных игр на картридже относительно начала 0-го банка ПЗУ




# Обрезаем переданные в программу аргументы (первым всегда является путь к исполняемому файлу программы)
args = sys.argv[1:]

# Если передано недостаточное количество аргументов, выходим с ошибкой
if len(args) < 1:
	print ('Invalid command line syntax')
	sys.exit(1)

# Парсим аргументы на нужные типы (входные файлы, выходной файл, ключи)
i = 0
keyR = 0 # 0 - дефолтная сборка в картридж, 1 - сборка в ПЗУ Эльф
outputFilePos = ''
inputFilePos = ''
while i < len(args):
	# Проверка аргумента на ключ
	if (((args[i][0]) == "-") and (len(args[i]) > 1)) :
		if ((args[i][1] == "R") or (args[i][1] == "r")):
			keyR = 1 # если указан ключ "-R" - сборка в ПЗУ Эльф
	else:		
	# Проверка на первый указанный файл
		if (outputFilePos == ""):
			outputFilePos = i
		else:
			inputFilePos = i
	i += 1

print ("\n")

# ------------------------------
# Проверка количества аргументов и вывод сообщения об ошибке, если чего-то не хватает
print ("Processing command line arguments... ", end='')
if ((outputFilePos == '') or (inputFilePos == '')):
	print ("ERROR! Not enough arguments")
	sys.exit(1)
else:
	print ("OK")






# --------------------------------
# Вывод режима сборки выходного файла
print ("\nROM build mode: ", end='')
if keyR == 0:
	print ("cartridge ROM")
else:
	print (maxROMBanksQuantity * 16 + 32, end='')
	print ("K ROM for ALF mainboard")


# Создаём выходной файл. Он пока пустой.
outFile = open (args[outputFilePos], "wb")

print ("\n")
print ("Checking for Files...")

# открываем файл с прошивкой Basic48
basic48_data = []
basic48_data = readFile (readConfig("Files","fileBasic48"), filesFolder)
# открываем файл с прошивкой alf
alf16k_data = []
alf16k_data = readFile (readConfig("Files","fileAlfROM"), filesFolder)
# открываем файл с распаковщиком Dehrust
dehrust_data = []
dehrust_data = readFile (readConfig("Files","fileDehrust"), filesFolder)
# открываем файл check128
check128_data = []
check128_data = readFile (readConfig("Files","fileCheck128"), filesFolder)
# открываем файл checkalf.cod
checkNov_data = []
checkNov_data = readFile (readConfig("Files","fileCheckNov"), filesFolder)
# открываем файл menu.cod
cheatMenu_data = []
cheatMenu_data = readFile (readConfig("Files","fileCheatMenu"), filesFolder)
# открываем файл с дополнительными функциями
func_data = []
func_data = readFile (readConfig("Files","fileFunc"), filesFolder)
# открываем загрузчик
ldblk_data = []
ldblk_data = readFile (readConfig("Files","fileLdblk"), filesFolder)


print ("\n")




#Создаём массив данных для заголовка образа ПЗУ.
outFileMassive = bytearray (gamesAddr)
fillByte (outFileMassive, hrustAddr, 0xFF) # Заполняем массив байтом #FF до начала распаковщика

# перенос распаковщика в заголовок образа ПЗУ
LDIR (dehrust_data,0,outFileMassive,hrustAddr,len(dehrust_data))
# перенос процедуры проверки ОЗУ на 128К в заголовок образа ПЗУ
LDIR (check128_data,0,outFileMassive,ch128Addr,len(check128_data))
# перенос процедуры проверки на "новодел" в заголовок образа ПЗУ
LDIR (checkNov_data,0,outFileMassive,chNovAddr,len(checkNov_data))
# перенос меню читов в заголовок образа ПЗУ
LDIR (cheatMenu_data,0,outFileMassive,cheatMenuAddr,len(cheatMenu_data))
# перенос файла функций в заголовок образа ПЗУ
LDIR (func_data,0,outFileMassive,funcAddr,len(func_data))
# перенос файла загрузчика в заголовок образа ПЗУ
LDIR (ldblk_data,0,outFileMassive,ldblkAddr,len(ldblk_data))



# Задаём первый байт образа в зависимости от типа сборки
if keyR == 0:
	outFileMassive[0] = ord ("S") # Сборка образа картриджа
else:
	outFileMassive[0] = 0xFF # При сборке образа ПЗУ для установки на плату Эльф




# Открываем входной файл со списком игр. Файл должен быть с кодировкой UTF8!!!
try:
		Inpfile = open(args[inputFilePos], encoding='UTF8')
except IOError as e:
		print ("Input file ", end='')
		print (args[inputFilePos], end='')
		print(' - read error or file not exist!')
		sys.exit(1)

inpFileContents = Inpfile.readlines() # Считываем весь файл в массив строк


print ("Processing games from file ", end='')
print (args[inputFilePos], end='')
print (" ...")



# Главный цикл. Перебираем файлы с играми
currentHeaderPos = 1-20 # +1 - Начальная позиция в заголовке выходного образа ПЗУ
currentAddr = gamesAddr # Текущий адрес начала игры в создаваемом образе ПЗУ
bankSmesh = 0x80
if keyR == 1:
	currentAddr += 0x8000 #Для сборки в образ ПЗУ Эльф адрес смещаем на #8000 (игры начинаются с банка 2)
	bankSmesh = 0

inpFileLine = 0 # Счётчик строк во входном файле
inpFileCount = 0 # Счётчик обработанных игр
while inpFileLine < len (inpFileContents): # Перебираем строки файла
		if inpFileContents[inpFileLine][0] != '#': # Строки с комментариями пропускаем
			words = inpFileContents[inpFileLine].split(", ") # Парсим строку на части
			if len(words) == 2: # Обрабатываем только те строки, где 2 параметра
				inpFileCount += 1 # Увеличиваем счётчик найденных игр
			
				# Оставляем в пути и имени файла только допустимые символы
				inpFileName = re.sub(r'[^a-zA-Z0-9\\._;#$@ \-]', '', words[1])
			
				print ('\n')
				print (inpFileCount, end='') # Вывод имени игры
				print ('. ', end='')
				print (words[0])

				# открываем файл с игрой
				games_data = bytearray(0)
				games_data1 = readFile (inpFileName,'')
				games_data += games_data1 # Массив с данными игры

				currentHeaderPos += 20 # Смещение в заголовке прошивки для новой игры

				#print ("HeaderPos = ", end='')
				#print (currentHeaderPos)

				#print ('\n')
				

				# переносим имя игры в заголовок ПЗУ
				inpFileName = bytearray(b'             ') # 13 байт длины - для имени файла игры
				inpFileName2 = ""
				if len(words[0]) < 13:
					maxFileNameLen = len(words[0])
				else:
					maxFileNameLen = 12
				i = 0
				while i < maxFileNameLen:
					encodedSym = symToAlf(words[0][i])
					inpFileName[i+1] = ord(encodedSym)
					inpFileName2 += encodedSym
					#print (chr(inpFileName[i+1]))
					i += 1
				LDIR (inpFileName,0,outFileMassive,currentHeaderPos,13) #Переносим имя игры (13 байт) в заголовок образа ПЗУ

				# Печать уже сконвертированного в формат приставки "Эльф" имени.
				print ('ALF name: ', end='')
				print (inpFileName2)
				
				# Проверяем корректность *.alf файла.
				# Анализируем список файлов внутри игры.
				i = 0
				while i < maxFiles: # Перебираем внутренний каталог файлов, пока не встретится его конец
					k = opisLen + 5*i + 8
					if games_data[k] == 0xFF: # Встретили конец внутреннего каталога
						break
					i += 1
				
				# Если не встретили конец каталога файлов
				if i == maxFiles :
					print ("\nInternal catalog end marker error")
					sys.exit(1)

				firstBankNum = games_data[opisLen + 7] # Первый байт перед внутренним каталогом файлов  - значение порта для первого банка ПЗУ картриджа / прошивки. Тут должно быть значение или #02 или #80. Другие значения не допускаются.

				# Проверка байта на корректное значение.
				if (firstBankNum != 0x02) and (firstBankNum != 0x80):
				# Если тут не #02 и не #80,  выдаём ошибку - такую игру нельзя собрать в образ ПЗУ на плату Эльф, она не поддаётся модификации
					print ("\nFile structure error")
					sys.exit(1)

				# "Достаём" из файла игры параметры загрузчика
				gameStartAddr = readNum (games_data, opisLen+2, 2) # В какое место памяти будет перенесен загрузчик игры
				gameLoaderAddr = readNum (games_data, opisLen+8, 3) # Смещение загрузчика относительно начала файла с игрой
				gameLoaderLen = readNum (games_data, opisLen+11, 2) # Длина загрузчика

				#print ('Length - ', end='')
				#print (decToHex (len(games_data), 4))
			

				# Непосредственно перенос данных файла игры внутрь выходного образа ПЗУ
				currentGameAddr = 0 # Текущий адрес в файле с игрой
				currentGameOst = len (games_data) # Текущий остаток данных в файле с игрой
	
				firstInteraction = 0 # Признак, что мы ещё не записали описание игры и загрузчик
				while currentGameOst != 0: # Цикл, пока не останется ни одного байта игры
				# Если до кратного размера 16К можно дописать байты
					to16kBytes = ((len(outFileMassive) // 16384) + 1) * 16384 - len(outFileMassive)
					if to16kBytes != 16384: # to16kBytes - сколько байт ещё "влезет" до конца текущего банка ПЗУ
						# Важное условие - загрузчик игры + описание игры должны поместиться внутрь банка ОЗУ!
						# Цифра 3 - после загрузчика ещё помещаются 3 байта с кодом запуска загрузчика (требования меню приставки Эльф)
						if ((to16kBytes >= (gameLoaderLen + opisLen + 3)) or (firstInteraction != 0)):
							if currentGameOst <= to16kBytes: # Если в остаток до конца банка ПЗУ можно вместить остаток игры
								to16kOst = currentGameOst
							else: # Иначе остаток игры слишком большой, и пишем столько, сколько влезет до конца банка
								to16kOst = to16kBytes
							
							#print (decToHex (currentAddr, 6), end='')
							#print ("(", end='')
							#print (decToHex (to16kOst, 4), end='')
							#print (")")

							if firstInteraction == 0:
								gameAddrROM = currentAddr + opisLen
								#print ("Start game addr: ", end='')
								#print (decToHex (gameAddrROM, 6))

								gameBank = gameAddrROM // 0x4000
								#print ('Bank - ', end='')
								#print (decToHex((gameBank + bankSmesh),2))
					
								gameSmesh = gameAddrROM - gameBank * 0x4000
								#print (decToHex (gameSmesh,4))

								outFileMassive[currentHeaderPos+13] = gameBank + bankSmesh #Заносим в заголовок прошивки номер банка для текущей игры
								writeNum (gameSmesh, 2, outFileMassive, currentHeaderPos+14) #Заносим в заголовок прошивки смещение от начала банка для текущей игры
								writeNum (gameStartAddr, 2, outFileMassive, currentHeaderPos+16) #Заносим в заголовок прошивки куда будет перенесён в память загрузчик
								writeNum (gameLoaderLen, 2, outFileMassive, currentHeaderPos+18) #Заносим в заголовок прошивки длину загрузчика
								writeNum (currentAddr, 3, games_data, opisLen + 4) # Заносим в файл игры адрес начала текущей игры относительно начала ПЗУ

							tempMassive = bytearray (to16kOst) # задаем массив для переноса блока даных
							LDIR (games_data,currentGameAddr,tempMassive,0,to16kOst) # заносим в него часть игры
							outFileMassive += tempMassive # добавляем наш массив к общему массиву прошивки
							currentGameAddr += to16kOst # увеличиваем адрес в файле с игрой
							currentAddr += to16kOst # увеличиваем адрес в файле с выходной прошивкой
							currentGameOst -= to16kOst # уменьшаем остаток необработанных байтов в игре
							firstInteraction = 1 # Признак, что загрузчик и описание записаны
						else: # загрузчик игры и описание не поместятся до конца банка ПЗУ
							
							#print (decToHex (currentAddr, 6), end='')
							#print ("(", end='')
							#print (decToHex (to16kBytes, 4), end='')
							#print (") ", end='')
							#print ("Не помещается")

							tempMassive = bytearray (to16kBytes) # задаем массив для заполнения байтами #FF
							i = 0
							while i < to16kBytes:
								tempMassive[i] = 0xFF
								i += 1
							outFileMassive += tempMassive # добавляем наш массив к общему массиву прошивки
							currentAddr += to16kBytes # увеличиваем адрес в файле с выходной прошивкой

					else: #Иначе у нас адрес, кратный 16, то есть начало банка ПЗУ, и туда надо вписать значение 0
						outFileMassive.append(0x00)

						#print (decToHex (currentAddr, 6), end='')
						#print ("- New bank")

						currentAddr += 1
		


		# Закончили обработку строки (с игрой или пустой)
		inpFileLine += 1 # Следующая строка во входном файле

currentHeaderPos += 20 # Смещение в заголовке прошивки для новой игры		
outFileMassive[currentHeaderPos] = 0xFF #Все игры перебрали, заносим байт #FF после окончания описателя последней игры

# Если во входном файле не нашли ни одной игры
if inpFileCount == 0:
	print ("\nERROR! No games detected in file ", end='')
	print (args[inputFilePos])
	sys.exit(1)

outFileLen = len (outFileMassive) # Длина сформированного массива данных для записи в выходной файл
outFileLen2 = outFileLen # Сохраним размер чисто данных с играми



# Добавляем к выходному файлу байты #FF, пока тот не станет кратным размеру 16К
to16kBytes = ((outFileLen // 16384) + 1) * 16384 - outFileLen
if to16kBytes != 16384: # Если надо добавлять байты
	to16kMassive = bytearray (to16kBytes) # Задаём пустой массив длиной сколько надо добавить байт
	i = 0
	while i < to16kBytes: # Заполняем массив значениями #FF
		to16kMassive[i] = 0xFF
		i += 1
	outFileMassive += to16kMassive # Дописываем массив значений #FF в выходной файл
	outFileLen += to16kBytes # Корректируем длину выходного файла


# ------------------------
# Постобработка для режима сборки образа для картриджа
# Проверка на предельный объём файла
if keyR == 0:
	if (outFileLen > maxCartridgeBanksQuantity * 0x4000): # Для режима сборки в образ картриджа проверяем на 1МБ
		print ("\nERROR! Output file size ", end='')
		print (outFileLen//1024, end='')
		print ('K is more than ', end='')
		print (maxCartridgeBanksQuantity * 16, end='')
		print ('K. File size is not supported by ALF TV GAME!')
		sys.exit(1)

	#print ('\nОбъёмы\n')

	# "Добиваем" объём файла пустыми банками по 16К до достижения размера, кратного степени 2, чтобы получить файл, готовый для прошивки в ПЗУ
	i = 17 # Начинаем проверку с объёма 2 в 14 степени - 16384
	while i < 21: # Максимальный объём - 2 в 20 степени - 1024К
		#print (2 ** i, end='')
		if outFileLen == 2 ** i:
			#print (' Уже есть')
			break

		if outFileLen < 2 ** i:
			emptyBank = (2 ** i - outFileLen)//16384
			#print (' Надо ', end='')
			#print (emptyBank, end='')
			#print (' банков ПЗУ')

			to16kMassive = bytearray (0x4000) # Формируем массив данных пустого банка ПЗУ
			to16kMassive[0] = 0x00 # Первый байт банка должен быть равен 0
			j = 1
			while j < 0x4000: # Заполняем остальные байты массива значением #FF
				to16kMassive[j] = 0xFF
				j += 1

			j = 0
			while j < emptyBank: # Цикл по количеству банков для добавления
				outFileMassive += to16kMassive # Дописываем массив значений #FF в выходной файл
				outFileLen += 0x4000
				j += 1
			break
		#else:
			#print (' -')


		i += 1

	outFile.write (outFileMassive) # Пишем в выходной файл сформированный массив данных

# ------------------------
# Постобработка для режима сборки образа для ПЗУ Эльф
# Для варианта сборки в виде ПЗУ на плату Эльф в начало файла добавляем 2 банка ПЗУ.
if keyR == 1:
	outFileMassive2 = bytearray(0) # Объявляем пустой массив для формирования записываемых данных
	outFileMassive2 += alf16k_data # Добавляем к нему прошивку ПЗУ для Эльф
	outFileMassive2 += basic48_data # Добавляем прошивку с BASIC-48
	outFileMassive2 += outFileMassive # Добавляем массив с обработанными играми

	outFileLen = len (outFileMassive2) # Длина сформированного массива данных для ПЗУ Эльф. Она будет кратна 16К.

	# "Добиваем" объём файла пустыми банками по 16К до достижения  размера 128K, чтобы получить файл, готовый для прошивки в ПЗУ
	maxROMalfSize = 0x8000 + maxROMBanksQuantity * 0x4000 # Максимальный объём ПЗУ для платы Эльф
	if outFileLen < maxROMalfSize:
		emptyBank = (maxROMalfSize - outFileLen)//16384
		#print (' Надо ', end='')
		#print (emptyBank, end='')
		#print (' банков ПЗУ')

		to16kMassive = bytearray (0x4000) # Формируем массив данных пустого банка ПЗУ
		to16kMassive[0] = 0x00 # Первый байт банка должен быть равен 0
		j = 1
		while j < 0x4000: # Заполняем остальные байты массива значением #FF
			to16kMassive[j] = 0xFF
			j += 1

		j = 0
		while j < emptyBank: # Цикл по количеству банков для добавления
			outFileMassive2 += to16kMassive # Дописываем массив значений #FF в выходной файл
			outFileLen += 0x4000
			j += 1



	if outFileLen > maxROMalfSize: # Для сборки в ПЗУ Эльф ограничение файла по длине 128 КБ
		print ("\nERROR! Output file size ", end='')
		print (outFileLen//1024, end='')
		print ('K is more than ',end='')
		print (maxROMBanksQuantity * 16, end='')
		print ('K. File size is not supported by ALF TV GAME!')
		sys.exit(1)

	outFile.write (outFileMassive2) # Пишем в выходной файл сформированный массив данных











outFile.close() # Закрываем выходной файл

# Вывод финальной информации о выходном файле
print ("\nOutput File: " + args[outputFilePos]) # Имя выходного файла

# Длина только данных с играми
print ("Data length = ", end='')
print (decToHex (outFileLen2, 6), end='') # Конвертация числа в удобный hex вид #xxxxxxx
print (' (dec ', end='')
print (outFileLen2, end='')
print (', ',end='')
print (round(outFileLen2/1024,1), end='') # Число килобайт с округлением
print ('K)')

# Длина сформированного файла с прошивкой
print ("ROM Length = ", end='')
print (decToHex (outFileLen, 6), end='') # Конвертация числа в удобный hex вид #xxxxxxx
print (' (dec ', end='')
print (outFileLen, end='')
print (', ',end='')
print (outFileLen//1024, end='')
print ('K)')


# Контрольная сумма
print ("Checksum = ", end='')
print (decToHex (checkSum(outFileMassive),4)) # Конвертация числа в удобный hex вид #xxxxxxx

print ("COMPLETED")

sys.exit(0)








